/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.util.Arrays;

public class CodegenUtils {
    public static String c(String string) {
        return string.replace('/', '.');
    }

    public static String p(Class clazz) {
        return clazz.getName().replace('.', '/');
    }

    public static String ci(Class clazz) {
        if (clazz.isArray()) {
            if ((clazz = clazz.getComponentType()).isPrimitive()) {
                if (clazz == Byte.TYPE) {
                    return "[B";
                }
                if (clazz == Boolean.TYPE) {
                    return "[Z";
                }
                if (clazz == Short.TYPE) {
                    return "[S";
                }
                if (clazz == Character.TYPE) {
                    return "[C";
                }
                if (clazz == Integer.TYPE) {
                    return "[I";
                }
                if (clazz == Float.TYPE) {
                    return "[F";
                }
                if (clazz == Double.TYPE) {
                    return "[D";
                }
                if (clazz == Long.TYPE) {
                    return "[J";
                }
                throw new RuntimeException("Unrecognized type in compiler: " + clazz.getName());
            }
            return "[" + CodegenUtils.ci(clazz);
        }
        if (clazz.isPrimitive()) {
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized type in compiler: " + clazz.getName());
        }
        return "L" + CodegenUtils.p(clazz) + ";";
    }

    public static String sig(Class clazz, Class ... classArray) {
        return CodegenUtils.sigParams(classArray) + CodegenUtils.ci(clazz);
    }

    public static String sig(Class clazz, String string, Class ... classArray) {
        return CodegenUtils.sigParams(string, classArray) + CodegenUtils.ci(clazz);
    }

    public static String sigParams(Class ... classArray) {
        StringBuilder stringBuilder = new StringBuilder("(");
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(CodegenUtils.ci(classArray[i]));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String sigParams(String string, Class ... classArray) {
        StringBuilder stringBuilder = new StringBuilder("(");
        stringBuilder.append(string);
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(CodegenUtils.ci(classArray[i]));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static Class[] params(Class ... classArray) {
        return classArray;
    }

    public static Class[] params(Class clazz, int n) {
        Object[] objectArray = new Class[n];
        Arrays.fill(objectArray, clazz);
        return objectArray;
    }

    public static Class[] params(Class clazz, Class clazz2, int n) {
        Object[] objectArray = new Class[n + 1];
        Arrays.fill(objectArray, clazz2);
        objectArray[0] = clazz;
        return objectArray;
    }
}

